% ----- identification -----
\ProvidesClass{SICFP23}[2022/04/11 SICFP23-paper class, based on SICFP21 by Liselott Ericson, altered by David Faßbender]
\NeedsTeXFormat{LaTeX2e}

% ----- declaration of options -----
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

% ----- execution of options -----
\ProcessOptions

% ----- package loading -----
\LoadClass[a4paper,onecolumn,10pt]{article}

% ----- initial code -----
\RequirePackage[a4paper,left=25mm,right=25mm,top=25mm,bottom=25mm,dvips,ignorehead]{geometry}

\RequirePackage{abstract}

\RequirePackage{mathptmx}        
\RequirePackage[scaled=.92]{helvet}

\RequirePackage[latin1]{inputenc}
\RequirePackage[T1]{fontenc}

\RequirePackage[british]{babel}
\RequirePackage{caption}
\renewcommand{\captionfont}{\it}
%\renewcommand\figurename{Fig.}
\RequirePackage{fancyhdr}
%\pagestyle{empty}
%\pagestyle{fancy}
%\cfoot{\thepage}
\fancyhead[R,LO]{}
\fancyhead[C,CO]{\normalsize{\textit{The 18th 
      Scandinavian International Conference on Fluid Power, SICFP'23, May 30- June 1, 2023, Tampere, Finland}}}
\fancyhead[L,RO]{}
\fancyfoot[C,CO]{}
\renewcommand{\headrulewidth}{0pt}
\linespread{1}
\setlength{\columnsep}{8mm}

% ----- Defines variables & counters -----
\def\keywords#1{\gdef\@keywords{#1}}
\keywords{}
\global\let\@spokesmen\@empty
\global\let\spokesmen\relax

% ----- main code -----

\renewcommand\section{\@startsection {section}{1}{\z@}%
     																 {-1.5ex \@plus -1ex \@minus -.2ex}%
     																 {0.3ex \@plus.2ex}%
   																	 {\normalfont\large\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
 																			{-1.5ex \@plus -1ex \@minus -.2ex}%
     																 {0.3ex \@plus.2ex} %
     																 {\normalfont\normalsize\bfseries}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
 																			{-1.5ex \@plus -1ex \@minus -.2ex}%
     																 {0.3ex \@plus.2ex}%
     																 {\normalfont\normalsize\bfseries}}

\renewenvironment{abstract}
{
\begin{center}
\vspace{0mm}\section*{\bf Abstract}
\end{center}
} %4mm => 1mm
{\ifx \@keywords \@empty
  \vspace{4mm}
  \else
  \\[\baselineskip]\textbf{Keywords:} \indent\@keywords\vspace{4mm}
  \fi}

\renewcommand\maketitle{\thispagestyle{fancy}\vspace*{5mm}
  \par
  \begingroup\centering
  \global\@topnum\z@   % Prevents figures from going at top of page.
  { \large\bfseries\Large \@title}\\[9mm]
  {\noindent \@author}\\
  \@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
  \vspace{8mm}
}

\setlength{\parindent}{0pt}
\setlength{\parskip}{1ex}
